import os
import openai
import random
import numpy as np
import json
import jsonlines
import time
from tqdm import tqdm
from rank_bm25 import BM25Okapi
import threading

# OPENAI_API_KEY = "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"
# OPENAI_API_KEY = "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"
OPENAI_API_KEY = "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"
openai.api_key = OPENAI_API_KEY

def ask_gpt4(question, thread_id, file_lock, line, unanswered_questions):
    messages=[{"role": "user", "content": question}]
    attempt_time = 0
    max_time = 20
    while attempt_time < max_time:
        try:
            response =  openai.ChatCompletion.create(
                            model="gpt-4",
                            max_tokens=1000,
                            temperature=1.2,
                            messages = messages)
            answer = response["choices"][0]["message"]["content"]

            with file_lock:
                with open('./gpt4_ans/whoops/anscom/test.jsonl','a') as outfile:
                    line['gpt4_rate'] = answer
                    outfile.write(json.dumps(line) + "\n")
                    break

        except openai.error.RateLimitError: # Rate limit exceeded
            attempt_time += 1
            time.sleep(0.2)
        except openai.error.Timeout: # Rate limit exceeded
            attempt_time += 1
            time.sleep(0.2)
        except openai.error.OpenAIError:
            attempt_time += 1
            raise Exception("Sorry, a problem happened")
    if attempt_time == max_time:
        unanswered_questions.append((question, thread_id, line))
        

def read_jsonline(sample_file):
    samples = []
    for line in sample_file.iter():
        sample = '''The option A: %s''' %(line['crowd_underspecified_captions'][0])
        samples.append(sample)
    return samples
        
if __name__=="__main__":
    caption_file = jsonlines.open('./data/whoops/random_icl/test.jsonl')
    explanation_file = jsonlines.open('./data/whoops/cb_icl/test.jsonl')
    corpus = read_jsonline(caption_file)
    file_lock = threading.Lock()
    threads = []
    unanswered_questions = []
    with tqdm(desc='Process', unit='it', total=51) as pbar: #5_6: (260); 10_12: (85); swow: (84)
        num = 0
        for line in explanation_file.iter():
            option_a = corpus[num]
            option_b = '''The option B: %s''' %(line['explanations'][0])
            start_prompt = '''Evaluate the equivalence of the following two captions for the question "Could you clarify why it seems to describe a scene that is considered strange or out of the ordinary?" ''' 
            middle_prompt = '''%s; %s''' %(option_a, option_b)
            last_prompt = ''' Please answer with True if option B provide more useful information to predict answer compared with option A, Answer with False if option A provide more useful information to predict answer compared with option B. Answer Equal if they provide same useful information to answer question.'''
            end_prompt = '''Please only return True, False or Equal.'''
            content = f'''{start_prompt}{middle_prompt}{last_prompt}{end_prompt}'''
            thread = threading.Thread(target=ask_gpt4, args=(content, num+1, file_lock, line, unanswered_questions))
            threads.append(thread)
            thread.start()
            num = num+1
            pbar.update()

        for thread in threads:
            thread.join()

        if unanswered_questions:
            retry_threads = []
            for question, thread_id, line in unanswered_questions:
                retry_thread = threading.Thread(target=ask_gpt4, args=(question, thread_id, file_lock, line, []))
                retry_threads.append(retry_thread)
                retry_thread.start()

            for thread in retry_threads:
                thread.join()
